---
obsidianUIMode: preview
---

Balancing combat encounters is notoriously difficult. Different groups of characters can bring very different capabilities to each battle, even at the same level. However, because monsters as they are typically presented are the average of their type, you can adjust the averages to subtly or dramatically change the difficulty of a given monster or group of monsters. By turning these "difficulty dials" for monsters, you can easily shift the tone of combat even in the middle of a battle.

## "Hit Point" Dial

Hit points given for monsters are the average of their Hit Dice. This means you can adjust hit points within the minimum and maximum of a monster's Hit Dice formula based on the individual story for that particular monster, the current pacing of the battle, or both.

For example, an average ogre has 59 hit points from 7d10 + 21 Hit Dice. This means a weak ogre might have as few as 28 hit points, while a particularly strong ogre might have 91. This lets you easily set up fights in which minion ogres might have fewer hit points while boss ogres have more. (As an even lazier rule of thumb, you can halve or double a monster's average hit points to give you a weaker or stronger version of that monster.)

You can turn this dial before a battle begins or even during the battle itself. If a battle drags, reduce the hit points of a monster to get it out of the fight earlier. If a battle feels like it will be over too quickly, increase the monster's hit points to make it hold up longer. Start with average hit points, and then turn the hit point dial one way or the other whenever doing so can make the game more fun.

## "Number of Monsters" Dial

The "number of monsters in a battle" dial alters combat challenge the most dramatically of all the dials — but because it's so clearly visible to players, this dial is also sometimes difficult to change during a fight.

If circumstances allow for it, some monsters might flee or automatically fall depending on the events of a fight. Undead might break if their necromancer master is killed, and many intelligent creatures will flee a fight they can't win. Other times, more monsters might enter the fray in a second wave if the first wave isn't standing up to the characters.

When developing a combat encounter in which you think you might turn this dial, consider beforehand how monsters might leave the battle or how other monsters might join the fight as reinforcements in a realistic way.

## "Damage" Dial

Increasing the amount of damage a monster deals on each attack increases the monster's threat and can make a dull fight more fun. In the same way, decreasing monster damage can help prevent a fight from becoming overwhelming if the characters are having trouble.

The static damage value noted in a monster's stat block represents the average of the damage formula for the monster's attack. If you use average damage, you can adjust the damage based on that formula. For example, an ogre deals 13 (2d8 + 4) bludgeoning damage with their greatclub attack, so you can set this damage at anywhere from 6 to 20 and still be within the range of what you might roll.

If you're a GM who rolls for damage, you can also turn the damage dial up by adding one or more additional damage dice. If you like, you can have an in-game reason for this increase. Perhaps an ogre sets its club on fire to deal an additional 4 (1d8) or 7 (2d6) fire damage. Or a particularly dangerous vampire with an unholy sword might deal an extra 27 (6d8) necrotic damage if you so choose. Adding these kinds of effects to a monster's attack is an excellent way of increasing a monster's threat in a way the players can clearly understand — and it has no upper limit.

## "Number of Attacks" Dial

Increasing or decreasing the number of attacks a monster makes has a larger effect on its threat than increasing its damage. You can increase a monster's number of attacks if it's badly threatened by the characters, just as you can reduce its attacks if the characters are having an easy time. An angry ogre left alone after its friends have fallen to the heroes might start swinging its club twice per Attack action instead of just once. Single creatures facing an entire party of adventurers often benefit from increasing their number of attacks.

## Mix and Match

You can turn any or all of these dials to tune a combat encounter and bring the most excitement to your game. Don't turn the dials just to make every battle harder, though. Sometimes cutting through great swaths of easy monsters is exactly the sort of situation players love.

Turning several dials together can change combat dramatically, helping to keep things feeling fresh. For example, a group of starving ogres might be weakened (lowering the hit point dial) but also frenzied in combat (turning up the attack dial). By adjusting these dials when designing encounters and during your game, you can keep the pacing of combat exciting and fun.
